#!/usr/bin/python3
"""
Simple source-code line count script, used for dev metrics only
"""
import os, sys
from glob import glob
srcenc = 'utf8'  

# python and kivy-lang 
mains = sorted(glob('*.py')) + sorted(glob('*.kv'))

extras0 = glob('tools/*.py')
extras0+= glob('tools/*.desktop')
extras0+= glob('pc-build/build-app-exe/build4.0/*.py')
extras0+= glob('pc-build/build-app-exe/build4.0/*.spec') 
extras0+= glob('pc-build/build-source/*.py')

# *.spec are gray (generated and edited)
extras1 = glob('frigcal-pc/*.desktop')
extras1+= glob('_dev-misc/UPLOAD-KEY/*.sh')
extras1+= glob('*.spec') + glob('*.xml')
extras1+= glob('_website/*.py') + glob('_website/*.sh')
extras1+= glob('_website/Frigcal/*.py')
extras1+= glob('_website/Frigcal/+screenshots/*.sh')
extras1+= glob('_website/Frigcal/+screenshots/_etc/*/*.sh')

# omit special-case dup for open-source publication
# moot in FC: source-cde package is in a separate dir
if os.path.exists('_website/Frigcal/code'):
    extras1.remove('_website/Frigcal/main.py')

# in-app docs (but not _website docs and not generated settings.JSON)
extras2 = sorted(glob('*.txt') + glob('*.html'))

# don't count embedded systems, even if forked/tweaked
# in FC, this means icalendar, pytz, and distro

tally = count = 0

def segment(files, accum=True):
    global tally, count
    stally, scount = 0, 0
    for fname in files:   # not sorted()        
        if not fname.startswith('__sloc'):
            fobj = open(fname, 'r', encoding=srcenc)
            lcnt = len(fobj.readlines())
            fobj.close()
            stally += lcnt
            scount += 1
            print(fname, '=>', lcnt)
    print('Segment sloc in %d file(s): %s\n' % (scount, stally))
    if accum:
        tally += stally
        count += scount

segment(mains)
segment(extras0, accum=True)
segment(extras1, accum=True)
segment(extras2, accum=True)

print(f'Total sloc in {count} files: {tally}')
print('(Sans some doc .txts, generated .jsons, website .htmls, showcode mods, build-tool mods)')

if sys.platform.startswith('win') and sys.stdout.isatty():
    input('Press Enter')    # if clicked, more or less


r"""
================================================================================
Example output (current counts/manifest; 3.0 was 7808 lines, 23 files):

common.py => 276
hangless.py => 231
icsfiletools.py => 381
main.py => 3141
monthgui.py => 2113
prestart_pc_tweaks.py => 422
searchgui.py => 276
settings.py => 336
settingsgui.py => 446
storage.py => 1877
allpopups.kv => 594
allscreens.kv => 440
common.kv => 246
main.kv => 240
Segment sloc in 14 file(s): 11019

tools\new_color_names.py => 19
tools\map_calendar_colors.py => 29
tools\_make-convert_legacy_colors-zipfile.py => 32
tools\convert_legacy_colors.py => 354
tools\map_category_colors.py => 76
tools\frigcal-linux.desktop => 40
pc-build/build-app-exe/build4.0\_winver-maker.py => 21
pc-build/build-app-exe/build4.0\build.py => 1000
pc-build/build-app-exe/build4.0\_Linux--Frigcal.spec => 56
pc-build/build-app-exe/build4.0\_macOS--Frigcal.spec => 73
pc-build/build-app-exe/build4.0\_Windows--Frigcal.spec => 70
pc-build/build-source\build.py => 174
Segment sloc in 12 file(s): 1944

_dev-misc/UPLOAD-KEY\set-env-vars--PRIOR.sh => 27
_dev-misc/UPLOAD-KEY\set-env-vars.sh => 40
buildozer.spec => 499
manifest-insert-application-attrs.xml => 1
_website\_publish.sh => 102
Segment sloc in 5 file(s): 669

about-template.txt => 66
help-message.txt => 172
runcounter.txt => 1
terms-of-use.txt => 15
Segment sloc in 4 file(s): 254

Total sloc in 35 files: 13886
(Sans some doc .txts, generated .jsons, website .htmls, showcode mods, build-tool mods)
[EOF]

================================================================================
"""
