"""
=====================================================
Edit the following Python dictionary to map legacy
category names to 4.0's preset category/color names.
Your 3.0 frigcal_configs.py may give starting values.

For colors, categories are used before calendars.
Colors here are used for events with a prior category.
Events without a prior category get their color from 
either their calender name in map_calendar_colors.py, 
an empty category name '' coded here, or a default 
'gray', attempted in that order.

See convert_legacy_colors.py for full usage info
and new_color_names.py for the new 4.0 color names.
This file contains example mappings: edit for yours.

Tip: you can use Python's dict(name='value') instead 
of {'name': 'value'} if names are entirely letters, 
numbers, or underscores (e.g., no spaces or periods). 
=====================================================
"""

category_colors = {

    # 'prior category': 'new category/color',

    'travel':           'lime',             
    'birthday':         'yellow',          
    'anniversary':      'red',            
    'milestone':        'steelblue',
    'business':         'orange',
    'pybooks':          'magenta',
    'education':        'purple',           
    'politics':         'maroon',         
    'weather':          'bisque',
    'conference':       'violet',
    'gadgets':          'yellowgreen',
    'other':            'teal',

    'Red Category':     'red',
    'Green Category':   'green',

    '_red':             'red',
    '_green':           'lime',            
    '_oldgreen':        'green',
    '_purple':          'purple',           
    '_oldpurple':       'blueviolet', 
    '_orange':          'orange',
    '_blue':            'cadetblue',
    '_wheat':           'salmon',
    '_cyan':            'cyan',
    '_gray':            'gray',             
    '_yellow':          'yellow',
    '_lavender':        'magenta',
    '_violet':          'violet',
    '_dark red':        'maroon',
    '_beige':           'tan',           

    '+blues':           'blue',
    '+christmas':       'green',
    '+Важное событие':  'navy',
    '+purples':         'purple',
    '+orangeblue':      'tomato',
    '+navygreen☂':     'teal',
    '+blackwhite':      'gold',
    '+blackred':        'maroon',
    '+重要事件':         'tomato', 
    '+greens':          'yellowgreen',
    '+neons':           'cyan',
    '+goth':            'chocolate',

    # default for events with neither category nor colored calendar, else gray
    # '':                 'khaki',

}
