#!/usr/bin/python3
"""
===============================================================================
Make a zipfile of this folder's script and its dependencies.  This zipfile
is made available both online and in the "tools" subfolder of app PC installs.
Requires ziptools (https://learning-python.com/ziptools.html) or code mods.
Run with the following, no venv required, no pre-delete required:
  $ cd ~/fc4/frigcal4.0/tools/convert-legacy-colors
  $ python3 _make-convert_legacy_colors-zipfile.py
===============================================================================
"""

import sys, os
from os import system, sep
 
python3 = sys.executable

ziphome = (
    r'C:\Users\me\Downloads\ziptools' if sys.platform.startswith('win') else
    '/Users/me/Downloads/ziptools'    if sys.platform.startswith('darwin') else
    '/home/me/Downloads/ziptools'     if sys.platform.startswith('linux') else
    'unsupported-host')

makezipfile = 'convert_legacy_colors.zip'
if os.path.exists(makezipfile):
    os.remove(makezipfile)

system(f'{python3} {ziphome}{sep}zip-create.py'
       f' {makezipfile}'
       f' *.py ..{sep}..{sep}icalendar ..{sep}..{sep}pytz -zip@ -skipcruft')

print('Zipfile created.')

